IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PED_CP_PEND_EMAIL]') 
					AND type in (N'U')) 
BEGIN
 
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	SET ANSI_PADDING ON
	CREATE TABLE [dbo].[EST_PED_CP_PEND_EMAIL](
	 
		[CD_EMP] [int] NOT NULL   ,
	 	[CD_FILIAL] [int] NOT NULL  ,
		[CD_PED] [int] NOT NULL  ,
		[CD_FORN] [int] NOT NULL,
		[CD_INT] [int] NOT NULL,
		[STS_ENV] [int] NOT NULL  ,
		[CD_ARQ] [int] NOT NULL  ,
		[DT_CAD] [datetime] NOT NULL ,

	 CONSTRAINT [PK_EST_PED_CP_PEND_EMAIL] PRIMARY KEY CLUSTERED 
	(	[CD_FILIAL],
		[CD_PED],
		[CD_EMP] )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, 
	ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	SET ANSI_PADDING OFF 

	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL]  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_PED_CP_PEND_EMAIL_EST_PED_CP] FOREIGN KEY([CD_EMP],[CD_FILIAL],[CD_PED])
	REFERENCES [dbo].[EST_PED_CP] ([CD_EMP],[CD_FILIAL],[CD_PED]) ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] CHECK CONSTRAINT [FK_EST_PED_CP_PEND_EMAIL_EST_PED_CP] 
	 
	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_CD_EMP] DEFAULT 0 FOR CD_EMP
		
	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_CD_FILIAL] DEFAULT 0 FOR CD_FILIAL

	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_CD_PED] DEFAULT 0 FOR CD_PED

	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_CD_FORN] DEFAULT 0 FOR CD_FORN

	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_CD_INT] DEFAULT 0 FOR CD_INT
	
	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_STS_ENV] DEFAULT 0 FOR STS_ENV
	
	ALTER TABLE [dbo].[EST_PED_CP_PEND_EMAIL] ADD CONSTRAINT
		[DF_EST_PED_CP_PEND_EMAIL_CD_ARQ] DEFAULT 0 FOR CD_ARQ
		 
END